<?php
/**
 * Master Cron with Multiple Timings & Lock System
 * Author: Tumhara dost ChatGPT 😄
 */

// Lock file system to prevent multiple runs
$lockFile = __DIR__ . "/cron_lock.txt";
if (file_exists($lockFile) && (time() - filemtime($lockFile) < 5)) { // 5 sec ka gap
    exit("Another instance is already running.\n");
}
file_put_contents($lockFile, date("Y-m-d H:i:s"));

// Target URLs with their intervals in seconds
$tasks = [
    ["url" => "https://jalwa3.live/niyamitakelasa_zehn.php", "interval" => 30],
    ["url" => "https://jalwa3.live/niyamitakelasa.php",      "interval" => 60],
    ["url" => "https://jalwa3.live/niyamitakelasa_drei.php", "interval" => 180],
    ["url" => "https://jalwa3.live/niyamitakelasa_funf.php", "interval" => 300],
];

// Log file path
$logFile = __DIR__ . "/cron_log.txt";

// Read last run times
$lastRunTimes = [];
if (file_exists(__DIR__ . "/last_run.json")) {
    $lastRunTimes = json_decode(file_get_contents(__DIR__ . "/last_run.json"), true);
}

// Current time
$now = time();

foreach ($tasks as $task) {
    $url = $task["url"];
    $interval = $task["interval"];
    $lastRun = isset($lastRunTimes[$url]) ? $lastRunTimes[$url] : 0;

    if (($now - $lastRun) >= $interval) {
        // Run the task
        $result = @file_get_contents($url);
        $status = $result !== false ? "SUCCESS" : "ERROR";
        
        // Log the result
        file_put_contents($logFile, date("[Y-m-d H:i:s]") . " $url => $status\n", FILE_APPEND);
        
        // Update last run time
        $lastRunTimes[$url] = $now;
    }
}

// Save updated last run times
file_put_contents(__DIR__ . "/last_run.json", json_encode($lastRunTimes));

// Remove lock
unlink($lockFile);

echo "Cron executed at " . date("Y-m-d H:i:s") . "\n";
?>
