<!DOCTYPE html>
<html lang="en">
<head>
  <meta charset="UTF-8">
  <meta name="viewport" content="width=device-width, initial-scale=1.0">
  <title>Admin Login</title>
  <style>
    /* DJ Style Animated Background */
    body {
      display: flex;
      justify-content: center;
      align-items: center;
      height: 100vh;
      background: linear-gradient(45deg, #ff0000, #ff7300, #ffeb00, #47ff00, #00ff62, #00ffb7, #006eff, #4800ff, #ff00d0);
      background-size: 400% 400%;
      animation: djLights 5s infinite alternate-reverse;
      overflow: hidden;
      margin: 0;
      font-family: Arial, sans-serif;
      transition: background 1s;
    }

    @keyframes djLights {
      0% { background-position: 0% 50%; }
      50% { background-position: 100% 50%; }
      100% { background-position: 0% 50%; }
    }

    /* Rain Effect */
    .rain-container {
      position: absolute;
      top: 0;
      left: 0;
      width: 100%;
      height: 100%;
      pointer-events: none;
      display: none;
    }

    .raindrop {
      position: absolute;
      width: 2px;
      height: 10px;
      background: rgba(255, 255, 255, 0.7);
      animation: fall linear infinite;
    }

    @keyframes fall {
      0% { transform: translateY(-100vh); opacity: 1; }
      100% { transform: translateY(100vh); opacity: 0; }
    }

    /* Login Box */
    .container {
      background: rgba(255, 255, 255, 0.9);
      padding: 20px;
      border-radius: 10px;
      text-align: center;
      box-shadow: 0px 0px 15px rgba(255, 255, 255, 0.5);
      width: 300px;
      position: relative;
      z-index: 10;
    }

    /* Game Maker Zone Title */
    .logo-text {
      font-size: 24px;
      font-weight: bold;
      color: #333;
      margin-bottom: 10px;
    }

    h1 {
      margin-bottom: 20px;
    }

    label {
      display: block;
      text-align: left;
      margin: 10px 0 5px;
    }

    input {
      width: 100%;
      padding: 8px;
      margin-bottom: 10px;
      border: 1px solid #ccc;
      border-radius: 5px;
    }

    button {
      width: 100%;
      padding: 10px;
      background: #007BFF;
      color: white;
      border: none;
      border-radius: 5px;
      cursor: pointer;
      font-size: 16px;
      transition: 0.3s;
    }

    button:hover {
      background: #0056b3;
    }

    /* WhatsApp Button */
    .whatsapp-button {
      display: flex;
      align-items: center;
      justify-content: center;
      margin-top: 10px;
      background: #25D366;
      color: white;
      padding: 10px 20px;
      border-radius: 5px;
      text-decoration: none;
      font-size: 16px;
      font-weight: bold;
    }

    .whatsapp-button img {
      width: 20px;
      margin-right: 8px;
    }
  </style>
</head>
<body>
  <!-- Rain Effect -->
  <div class="rain-container"></div>

  <div class="container">
    <div class="logo-text">UdaanWin</div> <!-- Logo Removed, Text Added -->
    <h1>Welcome Back!</h1>
    <form action="maulyikarisalu.php" method="post">
      <label for="username">Username:</label>
      <input type="text" id="username" name="username" required>
      <label for="password">Password:</label>
      <input type="password" id="password" name="password" required>
      <button type="submit">LOGIN</button>
      
      <?php 
        if(isset($_GET['err']) && $_GET['err'] == "true") {
      ?>
        <h4>Check your username or password</h4>
      <?php
        }
        else if(isset($_GET['msg']) && $_GET['msg'] == "true"){
      ?>
        <h4>Unauthorized access</h4>
      <?php
        }
        else if(isset($_GET['logout']) && $_GET['logout'] == "true"){
      ?>
        <h4>Logged out</h4>
      <?php 
        }
      ?>
    </form>

    <!-- WhatsApp Button -->
    <a class="whatsapp-button" href="https://wa.me/7678068479" target="_blank">
       Chat on WhatsApp
    </a>
  </div>

  <script>
    function createRain() {
      const rainContainer = document.querySelector('.rain-container');
      rainContainer.innerHTML = ''; // Purane drops clear kar do

      for (let i = 0; i < 100; i++) {
        const drop = document.createElement('div');
        drop.classList.add('raindrop');
        drop.style.left = Math.random() * 100 + 'vw';
        drop.style.animationDuration = (Math.random() * 2 + 2) + 's';
        rainContainer.appendChild(drop);
      }
    }

    function startRain() {
      document.body.style.background = "black"; // Rain ke time background black
      document.querySelector('.rain-container').style.display = 'block';
      createRain();
    }

    function stopRain() {
      document.body.style.background = ""; // DJ background wapas
      document.querySelector('.rain-container').style.display = 'none';
    }

    function rainCycle() {
      startRain();
      setTimeout(stopRain, 10000); // 10 sec tak rain
      setTimeout(rainCycle, 20000); // 10 sec baad phir se rain start
    }

    setTimeout(rainCycle, 10000); // Pehle 10 sec ke baad start
  </script>
</body>
</html>
