<?php
// withdrawall.php
// --------------------------------------------
// This script triggers CQ9, Spribe, and Ninesgame withdraws
// for a given userId and returns JSON response.
// --------------------------------------------

header('Content-Type: application/json; charset=utf-8');
header('Strict-Transport-Security: max-age=31536000');
header('Access-Control-Allow-Origin: *');
date_default_timezone_set('Asia/Kolkata');

$userid = isset($_GET['userid']) ? intval($_GET['userid']) : 0;

if ($userid <= 0) {
    echo json_encode([
        'status' => 'error',
        'msg' => 'Invalid or missing userid parameter'
    ], JSON_PRETTY_PRINT);
    exit;
}

// --------------------------------------------
// WITHDRAW URLs
// --------------------------------------------
$cq9_withdraw_url = "https://wuttsghdijsbbsh.yrehdjsfiafkjgkjgfsasc.yachts/sjcftrnicgfhfvfghdvhfvytyhthvrthtrhvrthrthrfrthtrhvrthvrthvcrthrthvctrvhtrhvrhcyhtyhrthr/cq9?action=withdraw&userid={$userid}&callbackurl=https://91clubgames.vip/mkapi/api/webapi/apifiles/cq9.php";
$spribe_withdraw_url = "https://wuttsghdijsbbsh.yrehdjsfiafkjgkjgfsasc.yachts/sjcftrnicgfhfvfghdvhfvytyhthvrthtrhvrthrthrfrthtrhvrthvrthvcrthrthvctrvhtrhvrhcyhtyhrthr/spribe?action=withdraw&userid={$userid}&callbackurl=https://91clubgames.vip/mkapi/api/webapi/apifiles/jdbpro.php";
$ninesgame_withdraw_url = "https://wuttsghdijsbbsh.yrehdjsfiafkjgkjgfsasc.yachts/sjcftrnicgfhfvfghdvhfvytyhthvrthtrhvrthrthrfrthtrhvrthvrthvcrthrthvctrvhtrhvrhcyhtyhrthr/ninesgame?action=withdraw&userid={$userid}&callbackurl=https://91clubgames.vip/mkapi/api/webapi/apifiles/ninesgame.php";

// --------------------------------------------
// RUN ALL CURLS IN PARALLEL
// --------------------------------------------
$multiCurl = curl_multi_init();

// CQ9
$ch1 = curl_init();
curl_setopt_array($ch1, [
    CURLOPT_URL => $cq9_withdraw_url,
    CURLOPT_RETURNTRANSFER => true,
    CURLOPT_FOLLOWLOCATION => true,
    CURLOPT_SSL_VERIFYPEER => false,
    CURLOPT_TIMEOUT => 10
]);

// Spribe
$ch2 = curl_init();
curl_setopt_array($ch2, [
    CURLOPT_URL => $spribe_withdraw_url,
    CURLOPT_RETURNTRANSFER => true,
    CURLOPT_FOLLOWLOCATION => true,
    CURLOPT_SSL_VERIFYPEER => false,
    CURLOPT_TIMEOUT => 10
]);

// Ninesgame (fixed: use $ch3 correctly)
$ch3 = curl_init();
curl_setopt_array($ch3, [
    CURLOPT_URL => $ninesgame_withdraw_url,
    CURLOPT_RETURNTRANSFER => true,
    CURLOPT_FOLLOWLOCATION => true,
    CURLOPT_SSL_VERIFYPEER => false,
    CURLOPT_TIMEOUT => 10
]);

// Add handles
curl_multi_add_handle($multiCurl, $ch1);
curl_multi_add_handle($multiCurl, $ch2);
curl_multi_add_handle($multiCurl, $ch3);

$running = null;
do {
    curl_multi_exec($multiCurl, $running);
    curl_multi_select($multiCurl);
} while ($running > 0);

// Get responses
$response1 = curl_multi_getcontent($ch1);
$response2 = curl_multi_getcontent($ch2);
$response3 = curl_multi_getcontent($ch3);

// Close handles
curl_multi_remove_handle($multiCurl, $ch1);
curl_multi_remove_handle($multiCurl, $ch2);
curl_multi_remove_handle($multiCurl, $ch3);
curl_multi_close($multiCurl);

// --------------------------------------------
// PARSE RESPONSES
// --------------------------------------------
function parse_response($resp) {
    $resp = trim($resp);

    // Direct numeric response (like ninesgame)
    if (is_numeric($resp)) {
        return ['balance' => (float)$resp];
    }

    // JSON inside text
    if ($resp && preg_match('/\{.*\}/', $resp, $match)) {
        $json = json_decode($match[0], true);
        if ($json !== null) {
            return $json;
        }
    }

    return ['raw' => $resp];
}

$result = [
    'status' => 'success',
    'userid' => $userid,
    'timestamp' => date('Y-m-d H:i:s'),
    'responses' => [
        'cq9' => parse_response($response1),
        'spribe' => parse_response($response2),
        'ninesgame' => parse_response($response3)
    ]
];

echo json_encode($result, JSON_PRETTY_PRINT | JSON_UNESCAPED_SLASHES);
?>
