<?php
include "../../conn.php";
include "../../functions2.php";

header('Content-Type: application/json; charset=utf-8');
header('Strict-Transport-Security: max-age=31536000');
header('Access-Control-Allow-Headers: Origin, X-Requested-With, Content-Type, Accept, Authorization');
header('Access-Control-Allow-Credentials: true');
$origin = isset($_SERVER['HTTP_ORIGIN']) ? $_SERVER['HTTP_ORIGIN'] : '';
header('Access-Control-Allow-Origin: ' . $origin);
header('vary: Origin');

date_default_timezone_set("Asia/Kolkata");
$shnunc = date("Y-m-d H:i:s");
$res = [
   'code' => 11,
   'msg' => 'Method not allowed',
   'msgCode' => 12,
   'serviceNowTime' => $shnunc,
];

$shonubody = file_get_contents("php://input");
$shonupost = json_decode($shonubody, true);

if ($_SERVER['REQUEST_METHOD'] != 'GET') {
   if (isset($shonupost['payTypeId']) && ($shonupost['payTypeId'] == '10138' || $shonupost['payTypeId'] == '10417')) {
       $bearer = explode(" ", $_SERVER['HTTP_AUTHORIZATION']);
       $author = $bearer[1];
       $is_jwt_valid = is_jwt_valid($author);
       $data_auth = json_decode($is_jwt_valid, 1);
       
       if($data_auth['status'] === 'Success') {
           $sesquery = "SELECT akshinak FROM shonu_subjects WHERE akshinak = '$author'";
           $sesresult = $conn->query($sesquery);
           $sesnum = mysqli_num_rows($sesresult);
           
           if($sesnum == 1) {
               $timestamp = time();
               $randomString = substr(str_shuffle("abcdefghijklmnopqrstuvwxyzABCDEFGHIJKLMNOPQRSTUVWXYZ0123456789"), 0, 10);
               
               // Generate JWT ID (JTI)
               $jti = sprintf('%04x%04x-%04x-%04x-%04x-%04x%04x%04x',
                   mt_rand(0, 0xffff), mt_rand(0, 0xffff),
                   mt_rand(0, 0xffff),
                   mt_rand(0, 0x0fff) | 0x4000,
                   mt_rand(0, 0x3fff) | 0x8000,
                   mt_rand(0, 0xffff), mt_rand(0, 0xffff), mt_rand(0, 0xffff)
               );
               
               // JWT Header
               $header = base64_encode(json_encode(['alg' => 'HS256', 'typ' => 'JWT']));
               
               // Determine payment type and related values
               if($shonupost['payTypeId'] == '10138') {
                   $subject = 'usdtPaymentSikkim' . $randomString;
                   $redirectBase = 'https://pay.91clubgames.vip/usdt/#/usdt';
                   $pavatiaidi = 11;
                   $amount = $shonupost['amount'] * 92;
                   $mula = 'UPAY-USDT';
               } else {
                   $subject = 'trxPaymentSikkim' . $randomString;
                   $redirectBase = 'https://pay.91clubgames.vip/trx/#/trx';
                   $pavatiaidi = 16;
                   $amount = $shonupost['amount'] * 10;
                   $mula = 'UPAY-TRX';
               }
               
               // Create the JWT Payload
               $payload = base64_encode(json_encode([
                   'sub' => $subject,
                   'exp' => $timestamp + 7200,
                   'iat' => $timestamp,
                   'jti' => $jti
               ]));
               
               // Generate the JWT Signature
               $secret = 'bdgshonuuncensored';
               $signature = hash_hmac('sha256', "$header.$payload", $secret, true);
               $signature_base64 = base64_encode($signature);
               
               // Combine Header, Payload, and Signature to form the Token
               $token = "$header.$payload.$signature_base64";
               
               // Store the token and related details in the database
               $shonuid = $data_auth['payload']['id'];
               $date = new DateTime();
               $uniqueTimestamp = $date->format("YmdHis") . $date->format("u");
               $formattedDate = $date->format("Y-m-d H:i:s");
               
               $dharavahi = "P" . $uniqueTimestamp;
               
               // Fetch user mobile number for reference
               $getmobile = "SELECT mobile FROM shonu_subjects WHERE id = '$shonuid'";
               $mobileresult = $conn->query($getmobile);
               $mobilerow = mysqli_fetch_assoc($mobileresult);
               $mobile = $mobilerow['mobile'];
               
               // Insert payment record in the database
               $sql = "INSERT INTO thevani (balakedara, motta, mula, duravani, dharavahi, ullekha, ekikrtapavati, dinankavannuracisi, madari, pavatiaidi, sthiti, `key`)
                       VALUES ('$shonuid', '$amount', '$mula', '$mobile', '$dharavahi', '', '', '$formattedDate', '".$shonupost['payTypeId']."', '$pavatiaidi', '0', '$token')";
               $conn->query($sql);
               
               // Prepare response data
               $data = [
                   'scanCodePay' => false,
                   'formBody' => null,
                   'formUrl' => '',
                   'redirectUrl' => $redirectBase . '?token=' . $token
               ];
               
               $res['data'] = $data;
               $res['code'] = 0;
               $res['msg'] = 'Succeed';
               $res['msgCode'] = 0;
               http_response_code(200);
           } else {
               $res['code'] = 4;
               $res['msg'] = 'No operation permission';
               $res['msgCode'] = 2;
               http_response_code(401);
           }
       } else {
           $res['code'] = 4;
           $res['msg'] = 'No operation permission';
           $res['msgCode'] = 2;
           http_response_code(401);
       }
   } else {
       $res['code'] = 7;
       $res['msg'] = 'Param is Invalid';
       $res['msgCode'] = 6;
       http_response_code(200);
   }
} else {
   http_response_code(405);
}

echo json_encode($res);
?>
