<?php 
include "../../conn.php";
include "../../functions2.php";

header('Content-Type: application/json; charset=utf-8');
header('Strict-Transport-Security: max-age=31536000');
header('Access-Control-Allow-Headers: Origin, X-Requested-With, Content-Type, Accept, Authorization');
header('Access-Control-Allow-Credentials: true');
$origin = isset($_SERVER['HTTP_ORIGIN']) ? $_SERVER['HTTP_ORIGIN'] : '';
header('Access-Control-Allow-Origin: ' . $origin);
header('vary: Origin');

date_default_timezone_set("Asia/Kolkata");
$shnunc = date("Y-m-d H:i:s");
$res = [
    'code' => 11,
    'msg' => 'Method not allowed',
    'msgCode' => 12,
    'serviceNowTime' => $shnunc,
];

if ($_SERVER['REQUEST_METHOD'] != 'POST') {
    $res['code'] = 11;
    $res['msg'] = 'Method not allowed';
    $res['msgCode'] = 12;
    http_response_code(405);
    echo json_encode($res);
    exit();
}

$shonubody = file_get_contents("php://input");
$shonupost = json_decode($shonubody, true);

if (!isset($shonupost['language'], $shonupost['random'], $shonupost['signature'], $shonupost['timestamp'])) {
    $res['code'] = 7;
    $res['msg'] = 'Param is Invalid';
    $res['msgCode'] = 6;
    http_response_code(200);
    echo json_encode($res);
    exit();
}

$language = mysqli_real_escape_string($conn, $shonupost['language']);
$random = mysqli_real_escape_string($conn, $shonupost['random']);
$signature = mysqli_real_escape_string($conn, $shonupost['signature']);

$shonustr = '{"language":'.$language.',"random":"'.$random.'"}';
$shonusign = strtoupper(md5($shonustr));

if($shonusign != $signature){
    $res['code'] = 5;
    $res['msg'] = 'Wrong signature';
    $res['msgCode'] = 3;
    http_response_code(200);
    echo json_encode($res);
    exit();
}

if (!isset($_SERVER['HTTP_AUTHORIZATION'])) {
    $res['code'] = 4;
    $res['msg'] = 'No authorization header';
    $res['msgCode'] = 2;
    http_response_code(401);
    echo json_encode($res);
    exit();
}

$bearer = explode(" ", $_SERVER['HTTP_AUTHORIZATION']);
$author = $bearer[1] ?? '';

if(empty($author)){
    $res['code'] = 4;
    $res['msg'] = 'Invalid token';
    $res['msgCode'] = 2;
    http_response_code(401);
    echo json_encode($res);
    exit();
}

$is_jwt_valid = is_jwt_valid($author);
$data_auth = json_decode($is_jwt_valid, true);

if(!$data_auth || $data_auth['status'] != 'Success'){
    $res['code'] = 4;
    $res['msg'] = 'No operation permission';
    $res['msgCode'] = 2;
    http_response_code(401);
    echo json_encode($res);
    exit();
}

$userId = (int)$data_auth['payload']['id'];

// Check if turntable exists
$checkQuery = "SELECT * FROM shonu_turntable WHERE user_id = $userId";
$checkResult = $conn->query($checkQuery);

if(!$checkResult){
    $res['code'] = 500;
    $res['msg'] = 'Database error';
    $res['msgCode'] = 500;
    http_response_code(500);
    echo json_encode($res);
    exit();
}

if(mysqli_num_rows($checkResult) == 0){
    // New user - insert with 2 spins
    $insertQuery = "INSERT INTO shonu_turntable (user_id, invited_wheel_amount, total_spins) VALUES ($userId, 0.00, 2)";
    if(!$conn->query($insertQuery)){
        $res['code'] = 500;
        $res['msg'] = 'Failed to create record';
        $res['msgCode'] = 500;
        http_response_code(500);
        echo json_encode($res);
        exit();
    }
    $availableSpins = 2;
} else {
    $row = mysqli_fetch_assoc($checkResult);
    $availableSpins = (int)$row['total_spins'];
}

// Check if first spin ever
$spinCountQuery = "SELECT COUNT(*) as spin_count FROM shonu_turntable_spins WHERE user_id = $userId";
$spinCountResult = $conn->query($spinCountQuery);
$spinCountRow = mysqli_fetch_assoc($spinCountResult);
$isFirstSpin = ($spinCountRow['spin_count'] == 0);

if($availableSpins <= 0){
    $res['code'] = 8;
    $res['msg'] = 'No spins left';
    $res['msgCode'] = 9;
    http_response_code(200);
    echo json_encode($res);
    exit();
}

// Get user name
$userQuery = "SELECT codechorkamukala FROM shonu_subjects WHERE id = $userId";
$userResult = $conn->query($userQuery);
$userRow = mysqli_fetch_assoc($userResult);
$userName = mysqli_real_escape_string($conn, $userRow['codechorkamukala'] ?? 'User');

// Determine prize
$prizeAmount = 0.00;
$isWin = false;
$firstInvitedWheelDatas = null;

if($isFirstSpin){
    // First spin - 4 box logic
    $boxes = [
        ['amount' => 0.00, 'isSelected' => false],
        ['amount' => 0.00, 'isSelected' => false],
        ['amount' => 0.00, 'isSelected' => false],
        ['amount' => 0.00, 'isSelected' => false]
    ];
    $selectedIndex = array_rand($boxes);
    $boxes[$selectedIndex]['isSelected'] = true;
    $prizeAmount = floatval($boxes[$selectedIndex]['amount']);
    $isWin = ($prizeAmount > 0);
    $firstInvitedWheelDatas = $boxes;
} else {
    // Normal spin
    $prizes = [
        ['amount' => 0.02, 'probability' => 0.35],
        ['amount' => 0.05, 'probability' => 0.25],
        ['amount' => 0.10, 'probability' => 0.15],
        ['amount' => 0.20, 'probability' => 0.10],
        ['amount' => 0.50, 'probability' => 0.08],
        ['amount' => 1.00, 'probability' => 0.05],
        ['amount' => 2.00, 'probability' => 0.02]
    ];
    
    $rand = mt_rand() / mt_getrandmax();
    $cumulative = 0;
    $selectedAmount = 0.00;
    
    foreach($prizes as $prize){
        $cumulative += $prize['probability'];
        if($rand <= $cumulative){
            $selectedAmount = $prize['amount'];
            break;
        }
    }
    
    $prizeAmount = $selectedAmount;
    $isWin = ($prizeAmount > 0);
}

// Record spin
$spinTime = date('Y-m-d H:i:s');
$insertSpinQuery = "INSERT INTO shonu_turntable_spins (user_id, prize_amount, spin_time, user_name) VALUES ($userId, $prizeAmount, '$spinTime', '$userName')";
$conn->query($insertSpinQuery);

// Update spins
$newSpins = $availableSpins - 1;
$updateQuery = "UPDATE shonu_turntable SET total_spins = $newSpins, updated_at = NOW()";

if($isWin && $prizeAmount > 0){
    $updateQuery .= ", invited_wheel_amount = invited_wheel_amount + $prizeAmount";
    // Update wallet
    $walletQuery = "UPDATE shonu_kaichila SET motta = motta + $prizeAmount WHERE balakedara = $userId";
    $conn->query($walletQuery);
}

$updateQuery .= " WHERE user_id = $userId";
$conn->query($updateQuery);

// Prepare response
$data = [
    'isFirstInvitedWheel' => $isFirstSpin,
    'prizeAmount' => (float)$prizeAmount,
    'isWin' => $isWin,
    'firstInvitedWheelDatas' => $firstInvitedWheelDatas,
    'availableSpins' => $newSpins
];

$res['data'] = $data;
$res['code'] = 0;
$res['msg'] = 'Succeed';
$res['msgCode'] = 0;
$res['serviceNowTime'] = $shnunc;

http_response_code(200);
echo json_encode($res);
exit();
?>