<?php
include "../../conn.php";
include "../../functions2.php";

// ----------------- Headers -----------------
header('Content-Type: application/json; charset=utf-8');
header('Strict-Transport-Security: max-age=31536000');
header('Access-Control-Allow-Headers: Origin, X-Requested-With, Content-Type, Accept, Authorization');
header('Access-Control-Allow-Credentials: true');

// Kisi bhi domain se allow karo
$origin = isset($_SERVER['HTTP_ORIGIN']) ? $_SERVER['HTTP_ORIGIN'] : '';
if ($origin) {
    header('Access-Control-Allow-Origin: ' . $origin);
} else {
    header('Access-Control-Allow-Origin: *');
}
header('Vary: Origin');

date_default_timezone_set("Asia/Kolkata");
$shnunc = date("Y-m-d H:i:s");

// ----------------- Default Response -----------------
$res = [
    'code' => 11,
    'msg' => 'Method not allowed',
    'msgCode' => 12,
    'serviceNowTime' => $shnunc,
];

// ----------------- Check POST -----------------
if ($_SERVER['REQUEST_METHOD'] == 'POST') {

    // Check Authorization Header
    if (!isset($_SERVER['HTTP_AUTHORIZATION'])) {
        $res['code'] = 4;
        $res['msg'] = 'Authorization header missing';
        $res['msgCode'] = 2;
        http_response_code(401);
        echo json_encode($res);
        exit();
    }

    $bearer = explode(" ", $_SERVER['HTTP_AUTHORIZATION']);
    $author = $bearer[1] ?? '';
    
    if (empty($author)) {
        $res['code'] = 4;
        $res['msg'] = 'Token missing';
        $res['msgCode'] = 2;
        http_response_code(401);
        echo json_encode($res);
        exit();
    }

    $is_jwt_valid = is_jwt_valid($author);
    $data_auth = json_decode($is_jwt_valid, true);

    if($data_auth && isset($data_auth['status']) && $data_auth['status'] === 'Success') {

        $userId = $data_auth['payload']['id'];

        // Get POST data
        $shonubody = file_get_contents("php://input");
        $shonupost = json_decode($shonubody, true);

        // Pagination with validation
        $pageNo = isset($shonupost['pageNo']) ? max(1, (int)$shonupost['pageNo']) : 1;
        $pageSize = isset($shonupost['pageSize']) ? max(1, (int)$shonupost['pageSize']) : 10;
        $offset = ($pageNo - 1) * $pageSize;

        try {
            // Total count
            $countQuery = "SELECT COUNT(*) AS total FROM shonu_withdrawals WHERE user_id=? AND withdrawal_type='turntable'";
            $countStmt = $conn->prepare($countQuery);
            $countStmt->bind_param("s", $userId);
            $countStmt->execute();
            $countResult = $countStmt->get_result();
            $totalCount = ($countResult && $row = $countResult->fetch_assoc()) ? (int)$row['total'] : 0;
            $totalPage = $pageSize > 0 ? ceil($totalCount / $pageSize) : 0;

            // Get withdrawals
            $list = [];
            if ($totalCount > 0) {
                $query = "SELECT amount, status, created_at 
                          FROM shonu_withdrawals 
                          WHERE user_id=? AND withdrawal_type='turntable' 
                          ORDER BY created_at DESC 
                          LIMIT ?, ?";
                $stmt = $conn->prepare($query);
                $stmt->bind_param("sii", $userId, $offset, $pageSize);
                $stmt->execute();
                $result = $stmt->get_result();

                if($result && $result->num_rows > 0){
                    while($row = $result->fetch_assoc()){
                        $list[] = [
                            'amount' => (float)$row['amount'],
                            'status' => $row['status'],
                            'time' => $row['created_at']
                        ];
                    }
                }
            }

            $res = [
                'code' => 0,
                'msg' => 'Success',
                'msgCode' => 0,
                'serviceNowTime' => $shnunc,
                'data' => [
                    'list' => $list,
                    'pageNo' => $pageNo,
                    'totalPage' => $totalPage,
                    'totalCount' => $totalCount
                ]
            ];

            echo json_encode($res);
            exit();

        } catch (Exception $e) {
            $res['code'] = 500;
            $res['msg'] = 'Database error';
            $res['msgCode'] = 500;
            http_response_code(500);
            echo json_encode($res);
            exit();
        }

    } else {
        $res['code'] = 4;
        $res['msg'] = 'Invalid or expired token';
        $res['msgCode'] = 2;
        http_response_code(401);
        echo json_encode($res);
        exit();
    }

} else {
    // OPTIONS request handle karo preflight ke liye
    if ($_SERVER['REQUEST_METHOD'] == 'OPTIONS') {
        http_response_code(200);
        exit();
    }
    
    $res['code'] = 11;
    $res['msg'] = 'Method not allowed';
    $res['msgCode'] = 12;
    http_response_code(405);
    echo json_encode($res);
    exit();
}
?>