<?php
include "../../conn.php";
include "../../functions2.php";

header('Content-Type: application/json; charset=utf-8');
header('Strict-Transport-Security: max-age=31536000');
header('Access-Control-Allow-Headers: Origin, X-Requested-With, Content-Type, Accept, Authorization');
header('Access-Control-Allow-Credentials: true');
$origin = isset($_SERVER['HTTP_ORIGIN']) ? $_SERVER['HTTP_ORIGIN'] : '';
header('Access-Control-Allow-Origin: ' . $origin);
header('Vary: Origin');

date_default_timezone_set("Asia/Kolkata");
$shnunc = date("Y-m-d H:i:s");

$res = [
    'code' => 11,
    'msg' => 'Method not allowed',
    'msgCode' => 12,
    'serviceNowTime' => $shnunc,
];

function generateUrl($fileName) {
    $protocol = "https://";
    $host = $_SERVER['HTTP_HOST'];
    $uri = $_SERVER['REQUEST_URI'];

    $pathParts = explode("/", trim($uri, "/"));
    if (!empty($pathParts) && count($pathParts) > 1) {
        array_pop($pathParts);
    }

    return $protocol . $host . "/" . implode("/", $pathParts) . "/" . $fileName;
}

// Usage
$referrerUrl = generateUrl("functionoz.php");
$serverUrl = generateUrl("functionoz2.php");

$shonubody = file_get_contents("php://input");
$shonupost = json_decode($shonubody, true);

if ($_SERVER['REQUEST_METHOD'] != 'GET') {
    if (
        isset($shonupost['language']) &&
        isset($shonupost['random']) &&
        isset($shonupost['signature']) &&
        isset($shonupost['timestamp'])
    ) {
        $language = htmlspecialchars(mysqli_real_escape_string($conn, $shonupost['language']));
        $random = htmlspecialchars(mysqli_real_escape_string($conn, $shonupost['random']));
        $signature = htmlspecialchars(mysqli_real_escape_string($conn, $shonupost['signature']));
        $vendorCode = htmlspecialchars(mysqli_real_escape_string($conn, $shonupost['vendorCode']));
        $gameCode = htmlspecialchars(mysqli_real_escape_string($conn, $shonupost['gameCode']));
        $phonetype = htmlspecialchars(mysqli_real_escape_string($conn, $shonupost['phonetype']));

        $shonustr = '{"gameCode":"' . $gameCode . '","language":' . $language . ',"phonetype":' . $phonetype . ',"random":"' . $random . '","vendorCode":' . $vendorCode . '}';
        $shonusign = strtoupper(md5($shonustr));

        if ($shonusign != $signature) {
            $bearer = explode(" ", $_SERVER['HTTP_AUTHORIZATION'] ?? '');
            $author = $bearer[1] ?? '';

            $is_jwt_valid = is_jwt_valid($author);
            $data_auth = json_decode($is_jwt_valid, true);

            if ($data_auth['status'] === 'Success') {
                $sesquery = "SELECT id, mobile FROM shonu_subjects WHERE akshinak = '$author'";
                $sesresult = $conn->query($sesquery);
                $sesnum = mysqli_num_rows($sesresult);
                $row = $sesresult->fetch_assoc();

                $uid = $row['id'] ?? null;
                $no = $row['mobile'] ?? null;
                


                if ($vendorCode == 18) {
                    $game = "https://91clubgames.vip/jili/v5?gameId={$gameCode}&mobile={$uid}&referrerUrl={$referrerUrl}";
                } elseif ($vendorCode === 'JILI') {
                    $game = "https://91clubgames.vip/jili/v5?gameId={$gameCode}&mobile={$uid}&referrerUrl={$referrerUrl}";
                } elseif ($vendorCode == 23) {
                    $game = "https://91clubgames.vip/home/post?uid={$no}&serverUrl={$serverUrl}&gType=0&mType={$gameCode}";
                } elseif ($vendorCode === 'CQ9') {
                    $game = "https://wuttsghdijsbbsh.yrehdjsfiafkjgkjgfsasc.yachts"
        . "/sjcftrnicgfhfvfghdvhfvytyhthvrthtrhvrthrthrfrthtrhvrthvrthvcrthrthvctrvhtrhvrhcyhtyhrthr/cq9"
        . "?gameid=" . urlencode($gameCode)
        . "&userid=" . urlencode($uid)
        . "&callbackurl=" . urlencode("https://91clubgames.vip/mkapi/api/webapi/apifiles/cq9.php");
                } else {
                     $game = "https://91clubgames.vip/#/home/AllLotteryGames/WinGo?id=1";
                }

                if ($sesnum === 1) {
                    $data['url'] = $game;
                    $data['returnType'] = 1;
                    $res['data'] = $data;
                    $res['code'] = 0;
                    $res['msg'] = 'Succeed';
                    $res['msgCode'] = 0;
                    http_response_code(200);
                    echo json_encode($res);
                    exit;
                } else {
                    $res['code'] = 4;
                    $res['msg'] = 'No operation permission';
                    $res['msgCode'] = 2;
                    http_response_code(401);
                    echo json_encode($res);
                    exit;
                }
            } else {
                $res['code'] = 4;
                $res['msg'] = 'No operation permission';
                $res['msgCode'] = 2;
                http_response_code(401);
                echo json_encode($res);
                exit;
            }
        } else {
            $res['code'] = 5;
            $res['msg'] = 'Wrong signature';
            $res['msgCode'] = 3;
            http_response_code(200);
            echo json_encode($res);
            exit;
        }
    } else {
        $res['code'] = 7;
        $res['msg'] = 'Param is Invalid';
        $res['msgCode'] = 6;
        http_response_code(200);
        echo json_encode($res);
        exit;
    }
} else {
    http_response_code(405);
    echo json_encode($res);
    exit;
}
?>
