<?php 
include "../../conn.php";
include "../../functions2.php";

header('Content-Type: application/json; charset=utf-8');
header('Strict-Transport-Security: max-age=31536000');
header('Access-Control-Allow-Headers: Origin, X-Requested-With, Content-Type, Accept, Authorization');
header('Access-Control-Allow-Credentials: true');
$origin = isset($_SERVER['HTTP_ORIGIN']) ? $_SERVER['HTTP_ORIGIN'] : '';
header('Access-Control-Allow-Origin: ' . $origin);
header('vary: Origin');

date_default_timezone_set("Asia/Kolkata");
$shnunc = date("Y-m-d H:i:s");
$res = [
    'code' => 11,
    'msg' => 'Method not allowed',
    'msgCode' => 12,
    'serviceNowTime' => $shnunc,
];

$shonubody = file_get_contents("php://input");
$shonupost = json_decode($shonubody, true);

if ($_SERVER['REQUEST_METHOD'] != 'GET') {

    if (isset($shonupost['language']) && isset($shonupost['random']) && isset($shonupost['signature']) && isset($shonupost['timestamp'])) {

        $language = htmlspecialchars(mysqli_real_escape_string($conn, $shonupost['language']));
        $random = htmlspecialchars(mysqli_real_escape_string($conn, $shonupost['random']));
        $signature = htmlspecialchars(mysqli_real_escape_string($conn, $shonupost['signature']));

        $shonustr = '{"language":'.$language.',"random":"'.$random.'"}';
        $shonusign = strtoupper(md5($shonustr));

        if($shonusign = $signature){

            $bearer = explode(" ", $_SERVER['HTTP_AUTHORIZATION']);
            $author = $bearer[1] ?? '';				
            $is_jwt_valid = is_jwt_valid($author);
            $data_auth = json_decode($is_jwt_valid, true);

            if($data_auth['status'] === 'Success') {

                $sesquery = "SELECT akshinak FROM shonu_subjects WHERE akshinak = '".mysqli_real_escape_string($conn, $author)."'";
                $sesresult = $conn->query($sesquery);
                $sesnum = mysqli_num_rows($sesresult);

                if($sesnum == 1){
                    $userId = (int)$data_auth['payload']['id'];

                    // Initialize data
                    $data = [
                        'codeWashAmount' => 0.0,
                        'dayRebate' => 0.0,
                        'totalRebate' => 0.0,
                        'washRate' => 0.0,
                        'washList' => []
                    ];

                    // Total codeWashAmount & totalRebate from rebetrec table
                    $totalQuery = "SELECT SUM(rebet) as totalRebet FROM rebetrec WHERE user_id = $userId";
                    $totalResult = $conn->query($totalQuery);
                    $totalRow = mysqli_fetch_array($totalResult);
                    $data['codeWashAmount'] = $totalRow['totalRebet'] !== null ? floatval(number_format($totalRow['totalRebet'],2)) : 0.0;
                    $data['totalRebate'] = $data['codeWashAmount'];

                    // Day rebate (today)
                    $dayQuery = "SELECT SUM(rebet) as dayRebet FROM rebetrec WHERE user_id = $userId AND DATE(created_at) = DATE('$shnunc')";
                    $dayResult = $conn->query($dayQuery);
                    $dayRow = mysqli_fetch_array($dayResult);
                    $data['dayRebate'] = $dayRow['dayRebet'] !== null ? floatval(number_format($dayRow['dayRebet'],2)) : 0.0;

                    // Latest 5 records for washList
                    $listQuery = "SELECT motta, rebet, rate, lvl, created_at 
                                  FROM rebetrec 
                                  WHERE user_id = $userId 
                                  ORDER BY created_at DESC 
                                  LIMIT 5";
                    $listResult = $conn->query($listQuery);
                    if($listResult && mysqli_num_rows($listResult) > 0){
                        while($row = mysqli_fetch_assoc($listResult)){
                            $data['washList'][] = [
                                'washVolume' => floatval($row['motta']),
                                'rebateAmount' => floatval(number_format($row['rebet'],2)),
                                'washRate' => floatval($row['rate']),
                                'lvl' => intval($row['lvl']),
                                'addTime' => $row['created_at']
                            ];
                        }
                    }

                    // Optional: set washRate as latest record's rate
                    if(!empty($data['washList'])){
                        $data['washRate'] = $data['washList'][0]['washRate'];
                    }

                    $res['data'] = $data;
                    $res['code'] = 0;
                    $res['msg'] = 'Succeed';
                    $res['msgCode'] = 0;
                    http_response_code(200);
                    echo json_encode($res);
                    exit();
                }

            }

        } else {
            $res['code'] = 5;
            $res['msg'] = 'Wrong signature';
            $res['msgCode'] = 3;
            http_response_code(200);
            echo json_encode($res);
            exit();
        }

    } else {
        $res['code'] = 7;
        $res['msg'] = 'Param is Invalid';
        $res['msgCode'] = 6;
        http_response_code(200);
        echo json_encode($res);
        exit();	
    }

} else {		
    http_response_code(405);
    echo json_encode($res);
}
?>
